package com.ElyStudio.leGaou.adapter;

import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import com.ElyStudio.leGaou.R;
import com.ElyStudio.leGaou.models.OnboardingItem;

import java.util.List;

public class OnboardingAdapter extends RecyclerView.Adapter<OnboardingAdapter.OnboardingViewHolder>{

    private List<OnboardingItem> onboardingItemList;

    public OnboardingAdapter(List<OnboardingItem> onboardingItemList) {
        this.onboardingItemList = onboardingItemList;
    }

    @NonNull
    @Override
    public OnboardingViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        return new OnboardingViewHolder(LayoutInflater.from(parent.getContext()).inflate(R.layout.onboarding_container,parent,false));
    }

    @Override
    public void onBindViewHolder(@NonNull OnboardingViewHolder holder, int position) {
        holder.setOnboardingData(onboardingItemList.get(position));
    }

    @Override
    public int getItemCount() {
        return onboardingItemList.size();
    }

    class OnboardingViewHolder extends RecyclerView.ViewHolder{
        private ImageView onboardingImage;
        private TextView onboardingTitle;
        private TextView onboardingDescription;


        public OnboardingViewHolder(@NonNull View itemView) {
            super(itemView);

            onboardingImage = itemView.findViewById(R.id.onboardingImage);
            onboardingTitle = itemView.findViewById(R.id.onboardingTitle);
            onboardingDescription = itemView.findViewById(R.id.onboardingDescription);
        }
        void setOnboardingData(OnboardingItem onboardingItem){
            onboardingImage.setImageResource(onboardingItem.getImage());
            onboardingTitle.setText(onboardingItem.getTitle());
            onboardingDescription.setText(onboardingItem.getDescription());
        }
    }
}
